#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_BloodUnitAntigen : BaseTest 
	{
		
		private DataTable _dtBloodUnitAntigen;
		private BOL.BloodUnitAntigen _tstBUA; 
		private System.Guid _unitGuid;

		[SetUp]
		protected void SetUp() 
		{
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtBloodUnitAntigen = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnitAntigen WHERE RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'",  false);
				if (this._dtBloodUnitAntigen.Rows.Count == 0)
				{
					Guid unitGuid = DataCreator.CreateBloodUnit(true).BloodUnitGuid;

					DataTable dtData = SprocHelper.GetInsertBloodUnitAntigenSprocTable(unitGuid);
					new Common.StoredProcedure().TransactionalGetValue(SPROCS.InsertBloodUnitAntigen.StoredProcName, dtData);

					this._dtBloodUnitAntigen = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnitAntigen WHERE RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'",  true);
				}

				this._unitGuid = (System.Guid)this._dtBloodUnitAntigen.Rows[0][TABLES.BloodUnitAntigen.BloodUnitGuid];

				this.RefreshData = false;
			}

			this._tstBUA = new BOL.BloodUnitAntigen(this._dtBloodUnitAntigen.Rows[0]);
		}


		[Test]
		public void Ctor_Blank_Pass()
		{
			BOL.BloodUnitAntigen tmpBUA = new BOL.BloodUnitAntigen();
			Assert.IsNotNull(tmpBUA);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Blank_Fail()
		{
		}

		[Test]
		public void Ctor_DataRow_Pass()
		{
			BOL.BloodUnitAntigen tmpBUA = new BOL.BloodUnitAntigen(this._dtBloodUnitAntigen.Rows[0]);

			Assert.IsTrue(tmpBUA.AntigenTypeId == (int)this._dtBloodUnitAntigen.Rows[0][TABLES.BloodUnitAntigen.AntigenTypeId]);
			Assert.IsTrue(tmpBUA.BloodUnitGuid == this._unitGuid);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_DataRow_Fail()
		{
		}

		[Test]
		public void BloodUnitGUID_Pass()
		{
			System.Guid tstValue = System.Guid.NewGuid();

			this._tstBUA.BloodUnitGuid = tstValue;
			Assert.IsTrue(this._tstBUA.BloodUnitGuid == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void BloodUnitGUID_Fail()
		{
		}

		[Test]
		public void AntigenTypeID_Pass()
		{
			int tstValue = new Random().Next(1,99);
			
			this._tstBUA.AntigenTypeId = tstValue;
			Assert.IsTrue(this._tstBUA.AntigenTypeId == tstValue);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(BOL.BusinessObjectException))]
		public void AntigenTypeID_Fail1()
		{
			this._tstBUA.AntigenTypeId = -1;
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(BOL.BusinessObjectException))]
		public void AntigenTypeID_Fail2()
		{
			this._tstBUA.AntigenTypeId = 10000;
		}

		[Test]
		public void Tested_Pass()
		{
			this._tstBUA.Tested = false;
			Assert.IsTrue(this._tstBUA.Tested == false);

			this._tstBUA.Tested = true ;
			Assert.IsTrue(this._tstBUA.Tested == true);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Tested_Fail()
		{
		}

		[Test]
		public void Positive_Pass()
		{
			this._tstBUA.Positive = false;
			Assert.IsTrue(this._tstBUA.Positive == false);

			this._tstBUA.Positive = true ;
			Assert.IsTrue(this._tstBUA.Positive == true);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Positive_Fail()
		{
		}

		[Test]
		public void RecordStatusCode_Pass()
		{
			Common.RecordStatusCode tstValue = Common.RecordStatusCode.Unknown;
			this._tstBUA.RecordStatusCode = tstValue;

			Assert.IsTrue(this._tstBUA.RecordStatusCode == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RecordStatusCode_Fail()
		{
		}

		[Test]
		public void AntigenName_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();
			this._tstBUA.AntigenName = tstValue;

			Assert.IsTrue(this._tstBUA.AntigenName == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void AntigenName_Fail()
		{
		}

		[Test]
		public void GetBloodUnitAntigens_Pass()
		{
			DataTable dtTest = BOL.BloodUnitAntigen.GetBloodUnitAntigens(this._unitGuid, UnitTestConfig.TestDivisionCode);
			Assert.IsTrue(dtTest.Rows.Count >= 0);
		}

		[Test]
		public void GetBloodUnitAntigens_Fail()
		{
			DataTable dtTest = BOL.BloodUnitAntigen.GetBloodUnitAntigens(System.Guid.NewGuid(), UnitTestConfig.TestDivisionCode);
			Assert.IsTrue(dtTest.Rows.Count == 0);
		}

		[Test]
		public void GetEmptyBloodUnitAntigenTable_Pass()
		{
			DataTable dtTest = BOL.BloodUnitAntigen.GetEmptyBloodUnitAntigenTable(true);

			Assert.IsTrue(dtTest.Columns.Count == 8);
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.BloodUnitAntigen.BloodUnitGuid));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.BloodUnitAntigen.AntigenTypeId));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.BloodUnitAntigen.Positive));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.BloodUnitAntigen.DivisionCode));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.BloodUnitAntigen.RecordStatusCode));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.BloodUnitAntigen.LastUpdateUser));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.BloodUnitAntigen.LastUpdateFunctionId));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.BloodUnitAntigen.RowVersion));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetEmptyBloodUnitAntigenTable_Fail()
		{
		}

		[Test]
		public void GetBloodUnitAntigensList_Pass()
		{
			System.Collections.ArrayList alTest = BOL.BloodUnitAntigen.GetBloodUnitAntigensList(this._unitGuid, UnitTestConfig.TestDivisionCode);

			Assert.IsTrue(alTest.Count >= 0);
		}

		[Test]
		public void GetBloodUnitAntigensList_Fail()
		{
			System.Collections.ArrayList alTest = BOL.BloodUnitAntigen.GetBloodUnitAntigensList(System.Guid.NewGuid(), UnitTestConfig.TestDivisionCode);

			Assert.IsTrue(alTest.Count == 0);
		}

		[Test]
		public void GetAllAntigensForBloodUnitList_Pass()
		{
			System.Collections.ArrayList alTest = BOL.BloodUnitAntigen.GetAllAntigensForBloodUnitList(this._unitGuid, UnitTestConfig.TestDivisionCode);

			Assert.IsTrue(alTest.Count >= 0);
		}

		[Test]
		public void GetAllAntigensForBloodUnitList_Fail()
		{
			System.Collections.ArrayList alTest = BOL.BloodUnitAntigen.GetAllAntigensForBloodUnitList(this._unitGuid, UnitTestConfig.TestDivisionCode);

			Assert.IsTrue(alTest.Count >= 0);
		}

		[Test]
		public void LoadDataRowFromThis_Pass()
		{
			DataRow dr = this._tstBUA.LoadDataRowFromThis(this._dtBloodUnitAntigen.NewRow());

			Assert.IsTrue((int)dr[TABLES.BloodUnitAntigen.AntigenTypeId] == this._tstBUA.AntigenTypeId);
			Assert.IsTrue((System.Guid)dr[TABLES.BloodUnitAntigen.BloodUnitGuid] == this._tstBUA.BloodUnitGuid);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadDataRowFromThis_Fail()
		{
		}


	}
}
#endif


